#ifndef __IDragPanelListener__
#define __IDragPanelListener__

#include "../Events/CDragEvent.hpp"
using Exponent::GUI::Events::CDragEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IDragPanelListener IDragPanelListener.hpp
			 * @brief Allows for responding to panel drag events
			 *
			 * @date 29/12/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IDragPanelListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IDragPanelListener
			{
			public:

//	===========================================================================

				/**
				 * Handle the drag starting
				 * @param event The event to handle
				 */
				virtual void handleDragBegining(CDragEvent &event) = 0;

				/**
				 * Handle the panel movement
				 * @param event The event to handle
				 */
				virtual void handleDrag(CDragEvent &event) = 0;

				/**
				 * Handle the drag ending
				 * @param event The event to handle
				 */
				virtual void handleDragEnding(CDragEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IDragPanelListener.hpp